<?php
/**
 * Display single product reviews (comments)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product-reviews.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.2.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

if ( ! comments_open() ) {
	return;
}

?>
<div id="reviews" class="woocommerce-Reviews">
<?php
	echo '<div id="comments" class="clearfix">';
	echo '<div class="clear"></div>';

	?>
	<h2 class="woocommerce-Reviews-title"><?php
		if ( get_option( 'woocommerce_enable_review_rating' ) === 'yes' && ( $count = $product->get_review_count() ) ) {
			/* translators: 1: reviews count 2: product name */
			printf( esc_html( _n( '%1$s review for %2$s', '%1$s reviews for %2$s', $count, 'woocommerce' ) ), esc_html( $count ), '<span>' . get_the_title() . '</span>' );
		} else {
			_e( 'Reviews', 'woocommerce' );
		}
	?></h2>
	<?php

	if ( have_comments() ) :

		echo '<ol class="commentlist">';

		wp_list_comments( array( 'callback' => 'woocommerce_comments' ) );

		echo '</ol>';

		if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>

			<div class="ui--pagination-wrapper clearfix">
				<ul class="ui--pagination unstyled clearfix">
					<li class="ui--box ui--gradient ui--gradient-grey">
						<?php previous_comments_link( ' <i class="fontawesome-angle-left px14"></i>' . cloudfw_translate( 'previous_page' ) ); ?>
					</li>
					<li class="ui--box ui--gradient ui--gradient-grey">
						<?php next_comments_link(  cloudfw_translate( 'next_page' ) . ' <i class="fontawesome-angle-right px14"></i>' ); ?>
					</li>
				</ul>
			</div>

		<?php endif;

	else :

		?>
			<p class="woocommerce-noreviews"><?php _e( 'There are no reviews yet.', 'woocommerce' ); ?></p>
		<?php

	endif;


	echo '</div>';

	if ( get_option( 'woocommerce_review_rating_verification_required' ) === 'no' || wc_customer_bought_product( '', get_current_user_id(), $product->get_id() ) ) :

		$commenter = wp_get_current_commenter();
		echo '<div id="review_form_wrapper"><div id="review_form">';

		$comment_form = array(
			'title_reply' => have_comments() ? __( 'Add a review', 'woocommerce' ) : sprintf( __( 'Be the first to review &ldquo;%s&rdquo;', 'woocommerce' ), get_the_title() ),
			'comment_notes_before' => '',
			'comment_notes_after' => '',
			'fields' => array(
				'author' => '<p class="comment-form-author">' . '<label for="author">' . __( 'Name', 'woocommerce' ) . '<span class="required">*</span>' . '</label> ' .
				            '<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" aria-required="true" /></p>',
				'email'  => '<p class="comment-form-email"><label for="email">' . __( 'Email', 'woocommerce' ) . '<span class="required">*</span>' . '</label> ' .
				            '<input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" aria-required="true" /></p>',
			),
			'label_submit' => __( 'Submit', 'woocommerce' ),
			'logged_in_as' => '',
			'comment_field' => ''
		);

		if ( get_option('woocommerce_enable_review_rating') == 'yes' ) {
			$rating_html = '<p class="comment-form-rating"><label for="ui--rating-selector">' . __( 'Your rating', 'woocommerce' ) .'</label><select name="rating" id="ui--rating-selector">
				<option value="">' . esc_html__( 'Rate&hellip;', 'woocommerce' ) . '</option>
				<option value="5">' . esc_html__( 'Perfect', 'woocommerce' ) . '</option>
				<option value="4">' . esc_html__( 'Good', 'woocommerce' ) . '</option>
				<option value="3">' . esc_html__( 'Average', 'woocommerce' ) . '</option>
				<option value="2">' . esc_html__( 'Not that bad', 'woocommerce' ) . '</option>
				<option value="1">' . esc_html__( 'Very poor', 'woocommerce' ) . '</option>
			</select></p>';

			if( is_user_logged_in() )
				$comment_form['comment_field'] .= $rating_html;
			else
				$comment_form['fields']['comment_field'] = $rating_html;
		}

		$comment_form['comment_field'] .= '<p class="comment-form-comment"><label for="comment">' . __( 'Your review', 'woocommerce' ) . '</label><textarea id="comment" name="comment" cols="45" rows="8" aria-required="true"></textarea></p>' . wp_nonce_field( 'woocommerce-comment_rating', '_wpnonce', true, false );

		cloudfw('comment_form', apply_filters( 'woocommerce_product_review_comment_form_args', $comment_form ));

		echo '</div></div>';

	else: ?>

		<p class="woocommerce-verification-required"><?php _e( 'Only logged in customers who have purchased this product may leave a review.', 'woocommerce' ); ?></p>

	<?php endif; ?>

	<div class="clear"></div>
</div>

