<?php

$wc_view = isset( $_GET['wc_view'] ) ? $_GET['wc_view'] : null;

if ( ! empty( $wc_view ) && function_exists('wc_setcookie') ) {
	wc_setcookie( PFIX . '_wc_view', sanitize_key( $wc_view ) );
	wp_redirect( esc_url( remove_query_arg( 'wc_view' ) ) );
}

/**
 *	UI Box
 */
if ( ! function_exists('cloudfw_UI_box_wc_list_view') ) {
	function cloudfw_UI_box_wc_list_view( $atts = array(), $content =  NULL ) {
		$atts = shortcode_atts(array(
			'id'                  => NULL,
			'class'               => NULL,
			'style'               => NULL,
			'margin_top'          => NULL,
			'margin_bottom'       => NULL,

			'media'               => '',
			'media_append'        => NULL,
			'image'               => NULL,
			'image_hover'         => NULL,
			'video'               => NULL,
			'video_type'          => 'auto',
			'video_embed'         => NULL,

			'title'               => NULL,
			'title_element'       => 'h3',
			'title_size'          => NULL,
			'title_height'        => NULL,
			'title_align'         => 'center',

			'show_caption'        => true,
			'caption'             => NULL,
			'caption_element'     => 'h6',

			'show_desc'           => true,

			'before_link_element' => '',
			'after_link_element'  => '',

			'media_link_append'   => NULL,
			'link'                => NULL,
			'link_style'          => 'all',
			'target'              => NULL,
			'nofollow'            => NULL,

			'hover_effect'        => NULL,
			'hover_text'          => NULL,
			'hover_icon'          => NULL,

			'overlay_content'     => '',

			'footer'              => NULL,
			'footer_align'        => 'left',

			'lightbox'            => false,
			'group'               => false,
			'group_prefix'        => '',

			'overlay'             => false,
			'overlay_bg'          => '',
			'icon'                => 'FontAwesome/icon-fullscreen',
			'button_text'         => '',
			'button_color'        => '',

			'columns'             => 3,
			'image_width'         => '',
			'image_height'        => '',
			'image_ratio'         => '16:9',
			'video_ratio'         => '16:9',

			'shadow'			  => 0,

			'gallery_effect'      => 'fade',
			'gallery_rotate_time' => 5000,
			'gallery_auto_rotate' => false,

			'images'              => array(),
			'lighbox_images'      => array(),

			'attr_alt'            => '',
			'attr_title'          => '',

			'overlay_prepend'     => '',
			'overlay_append'      => '',

		), _check_onoff_false($atts));
		extract($atts);

		global $product;
		$content = get_the_excerpt( $product->get_id() );

		ob_start();
			woocommerce_template_loop_add_to_cart(); // this adds "add to cart" button.
			$woocommerce_template_loop_add_to_cart = ob_get_contents();
		ob_end_clean();

		global $cloudfw_ui_box_id;
		if ( !isset($cloudfw_ui_box_id) )
			$cloudfw_ui_box_id = 0;

		$cloudfw_ui_box_id++;
		$box_id = $cloudfw_ui_box_id;

		$group_id = '';
		if ( $group == true ) {
			$group_id = 'box-group-' . $box_id;
		} elseif ( !empty($group_prefix) ) {
			$group_id = $group_prefix . '-group';
		}

		$content = do_shortcode( $content );
		if ( !empty( $content ) && !is_array($content) ) {
			$content = trim( $content );
		}
		$lightbox_title = '';
		$lightbox_description = esc_attr( strip_tags($title) );

		if( $button_text === 'NULL' ) {
			$button_text = '';
		}

		$shadow_wrap_classes = array();

		$classes = array();
		$classes[] = 'ui--content-box';
		$classes[] = 'ui--box-list';

		if ( ! $shadow  ) {
			$classes[] = 'ui--content-item';
			$classes[] = 'ui--animation';
		} else {
			$shadow_wrap_classes[] = 'ui--block ui--content-item ui--pass';
			$shadow_wrap_classes[] = 'ui--animation';
		}

		$classes[] = 'ui-row';
		$classes[] = $class;

		if ( empty($image_ratio) ) {
			$image_ratio = '16:9';
		}

		if ( empty($video_ratio) ) {
			$video_ratio = '16:9';
		}


		if ( !empty($link) || ($lightbox && ( !empty( $image ) || $group ) ) ) {
			if ( $lightbox && empty($link) ) {
				$link = $image;
			}

			$link = cloudfw_get_page_link( $link );
			if ( empty($link) ) {
				$link = 'javascript:;';
			}

			$link_element = array();
			$link_element[0]  = "<a class=\"ui--content-box-link\" href=\"{$link}\"";
			if ( !empty( $target ) ) {
				$link_element[0] .= " target=\"{$target}\"";
			}

			if ( !empty( $nofollow ) && ($nofollow == 'yes' || $nofollow === true) ) {
				$link_element[0] .= " rel=\"nofollow\"";
			}

			if ( $lightbox && !$group ) {
				$link_element[0] .= " data-rel=\"prettyPhoto";
				$link_element[0] .= "\"";
				$link_element[0] .= " data-title=\"". $lightbox_description ."\"";
			}

			$link_element[0] .= ">";
			$link_element[1]  = "</a>";
		} else {

			$link_element[0]  =
			$link_element[1]  = "";
		}

		$lighbox_api = array();

		if ( $group == true && $lightbox  ) {

			if ( !empty($lighbox_images) ) {

				foreach ($lighbox_images as $gallery_image) {
					if ( empty($gallery_image['src']) )
						continue;
						$lighbox_api['src'][] = $gallery_image['src'];
						$lighbox_api['desc'][] = !empty($gallery_image['title']) ? esc_attr( strip_tags($gallery_image['title']) ) : $lightbox_description;
				}

			}

		}

		/** Detect the media type */
		if ( !empty( $media ) ) {
			$media_type = $media;
		} else {
			if ( !empty( $video ) || !empty( $video_embed ) ) {
				$media_type = 'video';
			} elseif( !empty($images) && is_array($images) ) {
				$media_type = 'gallery';
			} elseif( !empty($image) ) {
				$media_type = 'image';
			} else {
				$media_type = false;
			}
		}

		$out = '';
		$out .= "<div ".
			cloudfw_make_id( $id ) .
			cloudfw_make_class($classes, true) .
			cloudfw_make_attribute( array(
			), FALSE ) .
			cloudfw_make_style_attribute( array(
				'margin-top'    => $margin_top,
				'margin-bottom' => $margin_bottom,
				'style'         => $style,
			), FALSE, TRUE ) .
			cloudfw_json_attribute( 'data-ligthbox', $lighbox_api, FALSE )
		.">";

			$out .= '<div class="ui-row row">';
				$out .= "<div class=\"ui-column span6\">";

					if ( !empty( $image_hover ) && $media_type == 'image' ) {
						$overlay_class = 'type--image-hover';
					} else {
						$overlay_class = 'type--default';
					}

					if( empty( $hover_effect ) || empty( $image_hover ) ) {
						$hover_effect = 'effect--fade';
					}

					/** Overlay Content */
					$overlay_content_html = '';
					if ( !empty($overlay_content) ) {
						$overlay_content_html .= "<div class=\"ui--content-box-overlay-content\">";
							$overlay_content_html .= "<div class=\"ui--content-box-overlay-content-text\">";
								$overlay_content_html .= cloudfw_inline_format( $overlay_content );
							$overlay_content_html .= "</div>";
						$overlay_content_html .= "</div>";
					}

					if ( $media_type ) {
						$media_ratio = $media_type == 'video' ? $video_ratio : $image_ratio;

						if ( $media_type == 'image' || $media_type == 'gallery' ) {
							$ratio_padding = cloudfw_match_ratio_percent( $media_ratio );
						} else {
							$ratio_padding = '';
						}

						$media_out = '';

						if ( $media_type == 'image' || $media_type == 'gallery' ) {


							list($image_width, $image_height) = cloudfw_image_size( $columns, $image_ratio );

							if ( $image_width ) {
								if ( ! empty( $image ) ) {
									$image = cloudfw_thumbnail( array( 'src'=> $image, 'w'=> $image_width, 'h'=> $image_height, 'retina' => cloudfw_is_retina() ) );
								}

								if ( !empty( $image_hover ) ) {
									$image_hover = cloudfw_thumbnail( array( 'src'=> $image_hover, 'w'=> $image_width, 'h'=> $image_height, 'retina' => cloudfw_is_retina() ) );
								}

							}

							if ( empty( $image_hover ) && !empty( $overlay_content ) ) {
								$image_hover = $image;
							}

							$overlay_html  = "";
							if ( $overlay || !empty( $image_hover ) ) {
								$overlay_html .= "<div class=\"ui--content-box-overlay\">";
									$overlay_html .= $overlay_prepend;

									if ( !empty($image_hover) ) {

										$overlay_html .= "<div class=\"ui--content-box-overlay-image\">";

											$overlay_html .= "<img ".
												cloudfw_make_class(array( 'ui--content-box-image' ), true) .
												cloudfw_make_attribute( array(
													'src'   => $image_hover,
													'alt' 	=> $attr_alt ? $attr_alt : $lightbox_title,
													'title' => $attr_title,
												), FALSE )
											."/>";

										$overlay_html .= "</div>";

									} else {

										$icon = cloudfw_make_icon( $icon );
										$overlay_html .= "<div class=\"ui--content-box-overlay-background\"".
											cloudfw_make_style_attribute( array(
												'background-color'    => $overlay_bg,
											), FALSE, TRUE )
										."></div>";
										$overlay_html .= "<div class=\"center\">";
											if ( !empty($button_text) || !empty($icon) ) {
												$overlay_html .= "<span class=\"btn ". esc_attr( cloudfw_make_button_style( ( !empty( $button_color ) ? $button_color : 'btn-grey' ), true ) ) . " ui--center-vertical\">";

													if ( $button_text )
														$overlay_html .= "<span class=\"ui--content-box-overlay-button-text\">{$button_text}</span>";

													if ( $icon )
														$overlay_html .= "<span class=\"ui--content-box-overlay-button-icon\">{$icon}</span>";

												$overlay_html .= "</span>";
											}
										$overlay_html .= "</div>";

									}

									$overlay_html .= $overlay_append;
								$overlay_html .= "</div>";
							}


							/** Gallery */
							if ( !empty($images) ) {

								$media_out .= cloudfw_UI_gallery()
										-> set('class', 'ui--content-box-gallery')
										-> set('slides_class', 'mini-slides')
										-> set('item_class', 'ui--content-box-gallery-item ui--content-box-link')
										-> set('image_class', 'ui--content-box-gallery-image')
										-> set('width', $image_width)
										-> set('height', $image_height)
										-> set('effect', $gallery_effect)
										-> set('auto_rotate', $gallery_auto_rotate)
										-> set('rotate_time', $gallery_rotate_time)
										-> items( $images )
										-> render();

								$media_out .= $link_element[0];
									$media_out .= $overlay_html;
									$media_out .= $media_link_append;
									$media_out .= $overlay_content_html;
								$media_out .= $link_element[1];

							} else {
								/** Single Image */

								if ( ! empty( $image ) ) {
									$media_out .= $link_element[0];
										$media_out .= "<div class=\"ui--content-box-image-default\">";
											$media_out .= "<img ".
												cloudfw_make_class(array( 'ui--content-box-image' ), true) .
												cloudfw_make_attribute( array(
													'src'   => $image,
													'alt' 	=> $attr_alt ? $attr_alt : $lightbox_title,
													'title' => $attr_title,
												), FALSE )
											."/>";
											$media_out .= $overlay_content_html;
										$media_out .= "</div>";
										$media_out .= $overlay_html;
										$media_out .= $media_link_append;
									$media_out .= $link_element[1];
								}

							}


						} elseif ( $media_type == 'video' ) {

							$media_out .= "<div class=\"ui--content-box-video clearfix\">";
								$video_obj = new CloudFw_Shortcode_Video();

								if( $video_type == 'manual' ) {
									$media_out .= $video_obj->shortcode( array( 'type' => 'manual', 'ratio' => $video_ratio ), $video_embed );
								} else {
									$media_out .= $video_obj->shortcode( array( 'type' => 'auto', 'url' => $video, 'ratio' => $video_ratio ) );
								}

							$media_out .= "</div>";
						}

						if ( ! empty( $media_out ) ) {

							$out .= "<div class=\"ui--content-box-media {$hover_effect} {$overlay_class} clearfix";
							if ( !$media_ratio || (! $ratio_padding && $media_type !== 'video' ) ) {
								$out .= " ratio-original";
							}
							$out .= "\"".
								cloudfw_make_style_attribute( array(
									'padding-bottom' => $ratio_padding,
								), FALSE, TRUE )
							.">";

							$out .= $media_out;
							$out .= $media_append;

							$out .= "</div>";
						}
					}
				$out .= "</div>";
				$out .= '<div class="ui-column span6">';
					if ( !empty($title) || (!empty($caption) && $show_caption ) ) {
						if ( get_option('woocommerce_enable_review_rating') == 'yes' ) {
							$out .= cloudfw_wc_rating_icons( '<div class="ui--star-rating-wrap">', '</div>', NULL, false );
						}

						$out .= $link_element[0];
						$out .= "<div class=\"ui--content-box-list-title clearfix text-left\">";

							if ( !empty($title) ) {
								$out .= "<{$title_element} class=\"ui--content-box-list-title-text\">";
									$out .= do_shortcode( $title );
								$out .= "</{$title_element}>";
							}

							if ( $show_caption && !empty($caption) ) {
								$out .= "<{$caption_element} class=\"ui--content-box-list-title-caption\">";
									$out .= do_shortcode( $caption );
								$out .= "</{$caption_element}>";
							}

						$out .= "</div>";
						$out .= $link_element[1] . $after_link_element;
					}

					/** Content */
					if ( !empty($content) && $show_desc ) {
						$out .= "<div class=\"ui--content-box-list-content\">";
							$out .= "<div class=\"ui--content-box-list-content-text\">";
								$out .= cloudfw_inline_format( $content );
							$out .= "</div>";
						$out .= "</div>";
					}

					if ( $price_html = $product->get_price_html() ) {
						$out .= '<div class="woocommerce-actions">';
							$out .= apply_filters( 'cloudfw_woocommerce_loop_footer_action_before', '' );
							$out .= '<a href="'. $link .'" class="btn btn-small '. esc_attr( cloudfw_make_button_style( cloudfw_get_option('woocommerce_button_color', 'price_tag', 'btn-primary'), true ) ) . '" style="">'. $price_html .'</a>';
							$out .= ' ';
							if ( ! cloudfw_check_onoff( 'woocommerce', 'catalog_mode' ) ) {
								$out .= '<div class="woocommerce-loading-wrap">';
									$out .= $woocommerce_template_loop_add_to_cart;
									$out .= '<a class="added_to_cart btn btn-small btn-green" data-i18n-view-cart="'. esc_attr( __('View Cart','woocommerce') ) .'" style="display:none;"><i class="fontawesome-ok"></i> '. cloudfw_translate( 'wc.loop.ajax_added' ) .'</a>';
								$out .= '</div>';
							}
							$out .= apply_filters( 'cloudfw_woocommerce_loop_footer_action_after', '' );
						$out .= '</div>';
					}

				$out .= "</div>";
			$out .= "</div>";
		$out .= "</div>";

		if ( !empty( $shadow ) ) {
			$out = cloudfw_UI_shadow( $shadow, $out, 'ui--shadow-abs ui--shadow-reset', '<div'. cloudfw_make_class( $shadow_wrap_classes, true ) .'>', '</div>' );
		}

		return $out;
	}

}