<?php

add_action('cloudfw_side_panel', 'cloudfw_side_widget_content');
function cloudfw_side_widget_content(){

	for ($i=1; $i <= 3; $i++) {

		$_enable_option = cloudfw_check_onoff( 'side_panel_' . $i, 'enable' );
		if ( $_enable_option ) {
			$page_ids_display = cloudfw_get_option( 'side_panel_' . $i, 'visibility_page_ids' );
			if ( ! empty( $page_ids_display ) ) {
				$page_ids_display = explode(',', $page_ids_display);
				$page_ids_display = array_map( 'trim', $page_ids_display );

				if ( ! empty( $page_ids_display ) && !is_page( $page_ids_display ) ) {
					$_enable_option = false;
				}
			}

			$page_ids_hide = cloudfw_get_option( 'side_panel_' . $i, 'visibility_page_ids_hide' );
			if ( ! empty( $page_ids_hide ) ) {
				$page_ids_hide = explode(',', $page_ids_hide);
				$page_ids_hide = array_map( 'trim', $page_ids_hide );

				if ( ! empty( $page_ids_hide ) && is_page( $page_ids_hide ) ) {
					$_enable_option = false;
				}
			}
		}

		$is_enable = apply_filters( "cloudfw_side_panel_$i", $_enable_option );

		if ( $is_enable ) {

			$id = cloudfw_get_option( 'side_panel_' . $i, 'page_id' );
			$title = cloudfw_get_option( 'side_panel_' . $i, 'title' );

			$data = cloudfw_get_page_content( $id, '', '', true );
			$content = isset($data['content']) ? $data['content'] : '';

			if ( empty( $title ) ) {
				$title = isset($data['title']) ? $data['title'] : '';
			}

	?>
		<div id="ui--side-content-widget-<?php echo $i; ?>">
			<h3><strong><?php echo $title; ?></strong></h3>
			<?php echo $content; ?>
		</div>
	<?php

		}

	}

}

add_action('wp_footer', 'cloudfw_side_widget_content_footer');
function cloudfw_side_widget_content_footer(){

	for ($i=1; $i <= 3; $i++) {

		$_enable_option = cloudfw_check_onoff( 'side_panel_' . $i, 'enable' );
		if ( $_enable_option ) {
			$page_ids_display = cloudfw_get_option( 'side_panel_' . $i, 'visibility_page_ids' );
			if ( ! empty( $page_ids_display ) ) {
				$page_ids_display = explode(',', $page_ids_display);
				$page_ids_display = array_map( 'trim', $page_ids_display );

				if ( ! empty( $page_ids_display ) && !is_page( $page_ids_display ) ) {
					$_enable_option = false;
				}
			}

			$page_ids_hide = cloudfw_get_option( 'side_panel_' . $i, 'visibility_page_ids_hide' );
			if ( ! empty( $page_ids_hide ) ) {
				$page_ids_hide = explode(',', $page_ids_hide);
				$page_ids_hide = array_map( 'trim', $page_ids_hide );

				if ( ! empty( $page_ids_hide ) && is_page( $page_ids_hide ) ) {
					$_enable_option = false;
				}
			}
		}

		$is_enable = apply_filters( "cloudfw_side_panel_$i", $_enable_option );

		if ( $is_enable ) {

			$icon = cloudfw_get_option( 'side_panel_' . $i, 'icon' );
			$icon = cloudfw_make_icon( $icon );

			if ( empty( $icon ) ) {
				continue;
			}

			$visibility = cloudfw_get_option( 'side_panel_' . $i, 'visibility' );
			$position = cloudfw_get_option( 'side_panel_' . $i, 'position' );

			if ( empty( $position ) ) {
				$position = 'bottom right';
			}

			$position = explode(' ', $position);
			$button_color = cloudfw_get_option( 'side_panel_' . $i, 'button_style', 'btn-primary' );

			echo '<div class="ui--fixed-button position--' . implode(' position--', $position) . ' ' . cloudfw_visible( $visibility ) . '">';
			echo cloudfw_create_button(array(
				'link'	=> 'javascript:;',
				'color' => $button_color,
				'block' => false,
				'lightbox' => false,
				'class'	=> 'ui--side-panel',
				'attributes' => array(
					'data-target' => 'ui--side-content-widget-' . $i,
				),
				'margin_top' => cloudfw_get_option('side_panel_' . $i, 'margin_top'),
				'margin_bottom' => cloudfw_get_option('side_panel_' . $i, 'margin_bottom'),
			), $icon);

			echo '</div>';

		}

	}

}